#include <stdio.h>
#include <stdlib.h>

typedef struct {
    long long x, y;
} Point;


int cmp_sum(const void *a, const void *b) {
    Point *p = (Point *)a;
    Point *q = (Point *)b;
    long long s1 = p->x + p->y;
    long long s2 = q->x + q->y;
    if (s1 != s2) return (s1 > s2) - (s1 < s2);
    return (p->x > q->x) - (p->x < q->x);
}


int cmp_diff(const void *a, const void *b) {
    Point *p = (Point *)a;
    Point *q = (Point *)b;
    long long d1 = p->x - p->y;
    long long d2 = q->x - q->y;
    if (d1 != d2) return (d1 > d2) - (d1 < d2);
    return (p->x > q->x) - (p->x < q->x);
}


long long count(Point *p, int n, int type) {
    long long res = 0;
    for (int i = 0; i < n; ) {
        int j = i;
       
        while (j < n &&
              ((type == 0 && p[j].x + p[j].y == p[i].x + p[i].y) ||
               (type == 1 && p[j].x - p[j].y == p[i].x - p[i].y)))
            j++;

       
        for (int a = i; a < j; a++) {
            for (int b = a + 1; b < j; b++) {
                long long dx = p[b].x - p[a].x;
                long long dy = p[b].y - p[a].y;

                if (type == 0) {
                   
                    if ((dx > 0 && dy < 0) || (dx < 0 && dy > 0))
                        res += 2;
                } else {
                  
                    if ((dx > 0 && dy > 0) || (dx < 0 && dy < 0))
                        res += 2;
                }
            }
        }

        i = j;
    }
    return res;
}

int main() {
    int N;
    scanf("%d", &N);
    Point *p = malloc(N * sizeof(Point));
    for (int i = 0; i < N; i++)
        scanf("%lld %lld", &p[i].x, &p[i].y);

    qsort(p, N, sizeof(Point), cmp_sum);
    long long ans = count(p, N, 0);

    qsort(p, N, sizeof(Point), cmp_diff);
    ans += count(p, N, 1);

    printf("%lld\n", ans);
    free(p);
    return 0;
}